/**
* =============================================================================
*  @file    tiny_ui_platform.h
*  @version 0.9.0
*
*  @brief   TINY_UI - GAL support header
*  @details This header contains references to MQX for the GAL (GPU abstraction 
*			layer)
*
*  @addtogroup TINY_UI
*  @{
* =============================================================================
#  Project              : TINY_UI
#  Platform             : VF6XX
#
#  SW Version           : 0.9.0
#  Build Version        : VF6XX_TINY_UI_0_9_0_BETA_201311
#
#  (c) Copyright 2011-2013 Freescale Inc.
#  All Rights Reserved.
* ==============================================================================
*/

#ifndef _tiny_ui_platform_h_
#define _tiny_ui_platform_h_

#include <stdint.h>

#ifndef NULL
#define NULL 		((void *)0)
#endif	

typedef void (* platform_sleep_func_t)(uint32_t);
typedef void (* platform_event_func_t)(volatile uint32_t *);
typedef void (* platform_int_func_t)(int32_t, void (* int_handler)(void *));

typedef struct
{
	platform_sleep_func_t sleep_func;
	platform_event_func_t event_func;
	platform_int_func_t int_install_func;
} tiny_ui_platform_init_t;

void tiny_ui_platform_init(tiny_ui_platform_init_t * init_struct);
void tiny_ui_platform_close(void);
void platform_time_delay(uint32_t milliseconds);
void platform_install_interrupt(int32_t interrupt, void (* int_func)(void *));
void platform_wait_event(volatile uint32_t * eventValue);
void _a5_dcache_flush();

#endif // _tiny_ui_platform_h_


/** @} */